﻿Imports www.LinksDALTableAdapters
Partial Public Class Links
    Inherits System.Web.UI.Page
    Public LinkService As New LinksBLL()
    Public Function ActivePassive(ByVal Status As Boolean) As String
        If Status = True Then
            Return "..\..\Images\UnLock.jpg"
        Else
            Return "..\..\Images\lock.jpg"
        End If

    End Function
    Public Function GroupName(ByVal ParentId As Object)
        If ParentId Is DBNull.Value Then
            Return "هیچکدام"
        Else
            Dim TableLink As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoryByLinkCategoryID(ParentId)
            If TableLink.Count > 0 Then
                Dim Row As LinksDAL.LinkCategoriesRow = TableLink.Rows(0)
                Return Row.Title
            Else
                Return "هیچکدام"
            End If
        End If
    End Function
    Public Function ServiceName(ByVal ServiceId As Object)
        Dim ServiceTable As LinksDAL.LinkServicesDataTable = LinkService.LinkServiceByLinkServiceID(ServiceId)
        Dim Row As LinksDAL.LinkServicesRow = ServiceTable.Rows(0)
        Return Row.ServiceName
    End Function
    Public Function Activation(ByVal Status As Object) As String
        Try
            If Status = True Then
                Return "فعال"
            ElseIf Status = False Then
                Return "غیرفعال"
            Else : Return "نامشخص"
            End If
        Catch ex As Exception
            Return Nothing
        End Try
    End Function
    Protected Sub buildchild(ByVal Parentnode As TreeNode, ByVal ParentID As Long?, ByVal ServiceID As Long?)
        If ParentID Is Nothing Then
            Dim CatagoryTable As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoriesByServiceID(ServiceID)
            For Each row As LinksDAL.LinkCategoriesRow In CatagoryTable.Rows
                If row.ParentID = 0 Then
                    Dim Node As New TreeNode With {.Text = row.Title, .NavigateUrl = "Links.aspx?Id=1&Serviceid=" + row.LinkServiceID.ToString() + "&CategoryId=" + row.LinkCategoryID.ToString()}
                    Parentnode.ChildNodes.Add(Node)
                    buildchild(Node, row.LinkCategoryID, Nothing)
                End If
            Next
        End If
        If ServiceID Is Nothing Then
            Dim LinkTable As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoriesByParentID(ParentID)
            For Each row As LinksDAL.LinkCategoriesRow In LinkTable.Rows
                Dim node As New TreeNode With {.Text = row.Title, .NavigateUrl = "Links.aspx?Id=1&Serviceid=" + row.LinkServiceID.ToString() + "&CategoryId=" + row.LinkCategoryID.ToString()}
                Parentnode.ChildNodes.Add(node)
                buildchild(node, row.LinkCategoryID, Nothing)
            Next
        End If
    End Sub
   
    Protected Sub treeload()
        Tree.Nodes.Clear()
        Dim parent As New TreeNode With {.Text = "لیست پیوندها", .SelectAction = TreeNodeSelectAction.None}
        Tree.Nodes.Add(parent)
        Dim ServiceTable As New LinksDAL.LinkServicesDataTable()
        ServiceTable = LinkService.LinkServices()
        For Each row As LinksDAL.LinkServicesRow In ServiceTable
            Dim ServiceNode As New TreeNode With {.Text = row.ServiceName, .NavigateUrl = "Links.aspx?id=0&Serviceid=" + row.LinkServiceID.ToString()}
            parent.ChildNodes.Add(ServiceNode)
            buildchild(ServiceNode, Nothing, row.LinkServiceID)
        Next
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        treeload()
        MultiView1.ActiveViewIndex = 0
        If Request.QueryString("Id") = 0 Then
            MultiView1.ActiveViewIndex = 0
            If (Page.IsPostBack = False) Then
                If Request.QueryString("ServiceId") <> Nothing Then
                    ListCatagoryName.Items.Clear()
                    Dim Item As New ListItem()
                    Item.Text = "(هیچکدام)"
                    Item.Value = 0
                    ListCatagoryName.Items.Add(Item)
                    ListServiceName.DataBind()
                    Dim ObjListServiceName As Object = ListServiceName.Items.FindByValue(Request.QueryString("Serviceid"))
                    Dim Indexlist1 As Integer = ListServiceName.Items.IndexOf(ObjListServiceName)
                    ListServiceName.SelectedIndex = Indexlist1
                    ListCatagoryName.DataBind()
                    GridViewLinkCategories.DataBind()
                    If GridViewLinkCategories.Rows.Count > 0 Then
                        CategorySelectedMenu.Visible = True
                    Else
                        CategorySelectedMenu.Visible = False
                    End If
                End If
            
            End If
            If (Page.IsPostBack = False) Then
                ListServiceName.DataBind()
                Dim i As Long = ListServiceName.SelectedValue
                DropDown()
                If GridViewLinkCategories.Rows.Count > 0 Then
                    CategorySelectedMenu.Visible = True
                Else
                    CategorySelectedMenu.Visible = False
                End If
            End If
        End If
        If Request.QueryString("Id") = 1 Then
            MultiView1.ActiveViewIndex = 1
            If Page.IsPostBack = False Then
                DropDownListUrlServiceName.DataBind()
                DropDownListUrlGroup.DataBind()
                LinksGrodView.DataBind()
                If LinksGrodView.Rows.Count > 0 Then
                    LinkSelectedMenu.Visible = True
                Else
                    LinkSelectedMenu.Visible = False
                End If
            End If
            If Request.QueryString("ServiceId") <> Nothing Then
                Dim s As String = Request.QueryString("ServiceId")
                Dim Value As Object = DropDownListUrlServiceName.Items.FindByValue(Request.QueryString("ServiceId"))
                Dim Index As Integer = DropDownListUrlServiceName.Items.IndexOf(Value)
                DropDownListUrlServiceName.SelectedIndex = Index
                DropDownListUrlServiceName.Enabled = False
                If Page.IsPostBack = False Then
                    DropDownListUrlGroup.Items.Clear()
                    DropDownListUrlGroup.DataBind()
                    Dim value2 As Object = DropDownListUrlGroup.Items.FindByValue(Request.QueryString("CategoryId"))
                    Dim index2 As Integer = DropDownListUrlGroup.Items.IndexOf(value2)
                    DropDownListUrlGroup.SelectedIndex = index2
                    LinksGrodView.DataBind()
                    If LinksGrodView.Rows.Count > 0 Then
                        LinkSelectedMenu.Visible = True
                    Else
                        LinkSelectedMenu.Visible = False
                    End If
                End If
            End If
        End If
     
    End Sub
    Private Sub ListServiceName_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles ListServiceName.SelectedIndexChanged
        DropDown()

        GridViewLinkCategories.DataBind()
        If GridViewLinkCategories.Rows.Count > 0 Then
            CategorySelectedMenu.Visible = True
        Else
            CategorySelectedMenu.Visible = False
        End If
    End Sub
    Protected Sub GridViewLinkCategories_RowCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles GridViewLinkCategories.RowCommand
        If e.CommandName = "LoadLinkCategories" Then
            Dim TableCategory As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoryByLinkCategoryID(e.CommandArgument)
            Dim Row As LinksDAL.LinkCategoriesRow = TableCategory.Rows(0)

            TxtGroupName.Text = Row.Title
            HiddenFieldTitle.Value = Row.Title
            ListServiceName.SelectedValue = Row.LinkServiceID
            ListItemEdit(Row.LinkCategoryID, Row.LinkServiceID)
            If String.IsNullOrEmpty(Row.ParentID) Then
                ListCatagoryName.SelectedValue = 0
            Else
                ListCatagoryName.SelectedValue = Row.ParentID
            End If

            TxtCategoryCustomOrder.Text = Row.CustomOrder
            If Row.Status = "True" Then
                RadioButtonListLinkCategory.SelectedValue = 1
            ElseIf Row.Status = "False" Then
                RadioButtonListLinkCategory.SelectedValue = 0
            End If
            Editor1.Content = If(String.IsNullOrEmpty(Row.Description), "", Row.Description)
            HiddenFieldCategoryID.Value = e.CommandArgument
            HiddenFieldOperator.Value = "Edit"
            BtnAction.Text = "به روز رسانی"
            ListServiceName.Enabled = False
        ElseIf e.CommandName = "DeleteLinkCategories" Then
            Dim Result As Integer = LinkService.DeletelinkCategoryByLinkCategoryID(e.CommandArgument)
            Select Case Result
                Case 1
                    ListCatagoryName.DataBind()
                    LabelSuccessLinkCategory.Visible = True
                    GridViewLinkCategories.DataBind()
                    If GridViewLinkCategories.Rows.Count > 0 Then
                        CategorySelectedMenu.Visible = True
                    Else
                        CategorySelectedMenu.Visible = False
                    End If
                Case -1, -2, -1000
                    LabelFailedLinkCategory.Visible = True

            End Select
            treeload()
            DropDown()
        ElseIf e.CommandName = "ChangeStatus" Then
            Dim Table As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoryByLinkCategoryID(e.CommandArgument)
            Dim Row As LinksDAL.LinkCategoriesRow = Table.Rows(0)
            Dim Status As Boolean = If(Row.Status = True, False, True)
            Dim UpdateResult As Integer = LinkService.UpdateLinkCategoryStatus(Status, e.CommandArgument)
            If UpdateResult = 1 Then
                LabelSuccessLinkCategory.Visible = True
                GridViewLinkCategories.DataBind()

            Else
                LabelFailedLinkCategory.Visible = True
            End If
        End If

    End Sub
    Public Sub ListItemEdit(ByVal CategoryID As Long, ByVal ServiceID As Long)
        ListCatagoryName.Items.Clear()
        Dim i As Integer
        Dim TableCategory As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoriesByServiceID(ServiceID)
        Dim Item As New ListItem()
        Item.Text = "(هیچکدام)"
        Item.Value = 0
        ListCatagoryName.Items.Add(Item)
        While i < TableCategory.Rows.Count
            Dim Row As LinksDAL.LinkCategoriesRow = TableCategory.Rows(i)
            If (Row.ParentID <> CategoryID) And (Row.LinkCategoryID <> CategoryID) Then
                Dim Item2 As New ListItem()
                Item2.Value = Row.LinkCategoryID
                Item2.Text = Row.Title
                ListCatagoryName.Items.Add(Item2)
            End If
            i += 1
        End While
    End Sub
    Public Function LinksGroupName(ByVal CategoryID As Long)
        Dim CategoryTable As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoryByLinkCategoryID(CategoryID)
        Dim Row As LinksDAL.LinkCategoriesRow = CategoryTable.Rows(0)
        Return Row.Title
    End Function
    Protected Sub BtnOperation_Click(ByVal sender As Object, ByVal e As EventArgs) Handles BtnOperation.Click
        If HiddenFieldoperation.Value = "Insert" Then
            LabelLinkTitleDublicate.Visible = False
            LabelUrlFaild.Visible = False
            LabelUrlSuccess.Visible = False
            Dim img(FileUploadurlThumImage.PostedFile.InputStream.Length) As Byte
            If FileUploadurlThumImage.HasFile Then
                img = FileUploadurlThumImage.FileBytes()
            Else
                img = Nothing
            End If
            Dim Result As Integer = LinkService.AddNewLink(DropDownListUrlGroup.SelectedValue, TextBoxLinkTitle.Text, EditorAttachmentDetailx.Text, "http://" + TextBoxURL.Text, Session("UserID"), TextBoxURLCustomOrder.Text, RadioButtonListUrlActivate.SelectedValue, img, FileUploadurlThumImage.PostedFile.ContentType)

            Select Case Result
                Case 1
                    LabelUrlSuccess.Visible = True
                Case -1, -1000
                    LabelUrlFaild.Visible = True
                Case -2
                    LabelLinkTitleDublicate.Visible = True
            End Select
            LinksGrodView.DataBind()
            If LinksGrodView.Rows.Count > 0 Then
                LinkSelectedMenu.Visible = True
            Else
                LinkSelectedMenu.Visible = False
            End If
            TextBoxLinkTitle.Text = ""
            EditorAttachmentDetailx.Text = ""
            TextBoxURL.Text = ""
            TextBoxURLCustomOrder.Text = 0
            treeload()
        ElseIf HiddenFieldoperation.Value = "Edit" Then
            LabelUrlSuccess.Visible = False
            LabelUrlFaild.Visible = False
            LabelLinkTitleDublicate.Visible = False

            Dim Result As Integer = LinkService.UpdateLinkByLinkID(HiddenLinkID.Value, DropDownListUrlGroup.SelectedValue, TextBoxLinkTitle.Text, EditorAttachmentDetailx.Text, "http://" + TextBoxURL.Text, Session("UserID"), TextBoxURLCustomOrder.Text, RadioButtonListUrlActivate.SelectedValue)
            Dim ResultUpdateImage As Integer = 1
            If FileUploadurlThumImage.HasFile Then
                ResultUpdateImage = LinkService.UpdateLinkThumbImage(FileUploadurlThumImage.FileBytes(), FileUploadurlThumImage.PostedFile.ContentType, HiddenLinkID.Value)
            End If
            Select Case Result
                Case 1
                    Select Case ResultUpdateImage
                        Case 1
                            LabelUrlSuccess.Visible = True
                            TextBoxLinkTitle.Text = ""
                            EditorAttachmentDetailx.Text = ""
                            TextBoxURL.Text = ""
                            TextBoxURLCustomOrder.Text = 0
                            LinksGrodView.DataBind()
                            HiddenFieldoperation.Value = "Insert"
                            BtnOperation.Text = "  ثبت  "
                        Case -1, -1000
                            LabelUrlFaild.Visible = True
                    End Select

                Case -2
                    LabelLinkTitleDublicate.Visible = True
                Case -1, -1000
                    LabelUrlFaild.Visible = True
            End Select

            treeload()
        End If
    End Sub
    Protected Sub DropDownListUrlServiceName_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles DropDownListUrlServiceName.SelectedIndexChanged
        DropDownListUrlGroup.Items.Clear()
        DropDownListUrlGroup.DataBind()

        GridViewLinkCategories.DataBind()
        If GridViewLinkCategories.Rows.Count > 0 Then
            CategorySelectedMenu.Visible = True
        Else
            CategorySelectedMenu.Visible = False
        End If
    End Sub
    Protected Sub LinksGrodView_RowCommand(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewCommandEventArgs) Handles LinksGrodView.RowCommand
        If e.CommandName = "EditLink" Then
            Dim TableLink As LinksDAL.LinksDataTable = LinkService.LinksByLinkID(e.CommandArgument)
            Dim Row As LinksDAL.LinksRow = TableLink.Rows(0)
            TextBoxLinkTitle.Text = Row.Title
            HiddenFieldLinkTitle.Value = Row.Title
            TextBoxURL.Text = Row.URL.Replace("http://", "")
            TextBoxURLCustomOrder.Text = Row.CustomOrder.ToString()
            DropDownListUrlServiceName.Enabled = False
            DropDownListUrlGroup.SelectedValue = Row.LinkCategoryID
            EditorAttachmentDetailx.Text = If(String.IsNullOrEmpty(Row.Description), "", Row.Description)
            If Row.Status = "True" Then
                RadioButtonListUrlActivate.SelectedValue = 1
            ElseIf Row.Status = "False" Then
                RadioButtonListUrlActivate.SelectedValue = 0
            End If
            HiddenLinkID.Value = e.CommandArgument
            HiddenFieldoperation.Value = "Edit"
            BtnOperation.Text = "به روز رسانی"
        ElseIf e.CommandName = "DeleteLink" Then
            Dim Result As Integer = LinkService.DeleteLinkByLinkID(e.CommandArgument)
            Select Case Result
                Case 1
                    LabelUrlSuccess.Visible = True
                    LinksGrodView.DataBind()
                    If LinksGrodView.Rows.Count > 0 Then
                        LinkSelectedMenu.Visible = True
                    Else
                        LinkSelectedMenu.Visible = False
                    End If
                Case -1, -1000
                    LabelUrlFaild.Visible = True
            End Select
            treeload()
        ElseIf e.CommandName = "Changestatus" Then
            Dim Table As LinksDAL.LinksDataTable = LinkService.LinksByLinkID(e.CommandArgument)
            Dim row As LinksDAL.LinksRow = Table.Rows(0)
            Dim Status As Boolean = If(row.Status = True, False, True)
            Dim UpdateResult As Integer = LinkService.UpdateLinkStatus(Status, e.CommandArgument)
            If UpdateResult = 1 Then
                LabelUrlSuccess.Visible = True
                LinksGrodView.DataBind()
            Else
                LabelUrlFaild.Visible = True
            End If
        End If
    End Sub

    Protected Sub BtnAction_Click(ByVal sender As Object, ByVal e As EventArgs) Handles BtnAction.Click
        Dim ParentId As Long?
        If ListCatagoryName.SelectedIndex = 0 Then
            ParentId = Nothing
        Else
            ParentId = Convert.ToInt64(ListCatagoryName.SelectedValue)
        End If
        If HiddenFieldOperator.Value = "Insert" Then
            LabelDublicateCategoryName.Visible = False
            LabelSuccessLinkCategory.Visible = False
            LabelFailedLinkCategory.Visible = False
            Dim result As Integer
            result = LinkService.AddNewLinkCategory(ParentId, ListServiceName.SelectedValue, TxtGroupName.Text, Editor1.Content, Session("UserID"), Convert.ToInt16(TxtCategoryCustomOrder.Text), RadioButtonListLinkCategory.SelectedValue)
            Select Case result
                Case 1
                    LabelSuccessLinkCategory.Visible = True

                Case -1, -1000
                    LabelFailedLinkCategory.Visible = True
                Case -2
                    LabelDublicateCategoryName.Visible = True
            End Select
            TxtGroupName.Text = ""
            Editor1.Content = ""
            TxtCategoryCustomOrder.Text = 0
            GridViewLinkCategories.DataBind()
            If GridViewLinkCategories.Rows.Count > 0 Then
                CategorySelectedMenu.Visible = True
            Else
                CategorySelectedMenu.Visible = False
            End If
            ListCatagoryName.DataBind()
            treeload()
            DropDown()
            GridViewLinkCategories.DataBind()
        ElseIf HiddenFieldOperator.Value = "Edit" Then
            LabelDublicateCategoryName.Visible = False
            LabelSuccessLinkCategory.Visible = False
            LabelFailedLinkCategory.Visible = False


            Dim result As Integer = LinkService.UpdateLinkCategoryByLinkCategoryID(ParentId, ListServiceName.SelectedValue, TxtGroupName.Text, Editor1.Content, Session("UserID"), Convert.ToInt16(TxtCategoryCustomOrder.Text), RadioButtonListLinkCategory.SelectedValue, HiddenFieldCategoryID.Value)
            Select Case result
                Case 1
                    LabelSuccessLinkCategory.Visible = True
                    TxtCategoryCustomOrder.Text = 0
                    TxtGroupName.Text = ""
                    Editor1.Content = ""
                    TxtGroupName.Focus()
                    ListServiceName.Enabled = True
                    ListCatagoryName.DataBind()
                    BtnAction.Text = "  ثبت  "
                    HiddenFieldOperator.Value = "Insert"
                    treeload()
                    DropDown()
                    GridViewLinkCategories.DataBind()
                Case -1, -1000
                    LabelFailedLinkCategory.Visible = True
                Case -2
                    LabelDublicateCategoryName.Visible = True
            End Select


        End If
    End Sub
    Protected Sub BtnCancelCategory_Click(ByVal sender As Object, ByVal e As EventArgs) Handles BtnCancelCategory.Click
        Response.Redirect("~/CPanel/Default.aspx")
    End Sub
    Public Sub DropDown()
        ListCatagoryName.Items.Clear()
        Dim ServiceID As Long = ListServiceName.SelectedValue
        Dim CategoryTable As LinksDAL.LinkCategoriesDataTable = LinkService.LinkCategoriesByServiceID(ServiceID)
        Dim i As Integer = 0
        Dim Item As New ListItem()
        Item.Text = "(هیچکدام)"
        Item.Value = 0
        ListCatagoryName.Items.Add(Item)
        While i < CategoryTable.Rows.Count
            Dim a As New ListItem()
            Dim Row As LinksDAL.LinkCategoriesRow = CategoryTable.Rows(i)
            a.Text = Row.Title
            a.Value = Row.LinkCategoryID
            ListCatagoryName.Items.Add(a)
            i += 1
        End While
    End Sub

    Protected Sub DropDownListUrlGroup_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles DropDownListUrlGroup.SelectedIndexChanged
        LinksGrodView.DataBind()
        If LinksGrodView.Rows.Count > 0 Then
            LinkSelectedMenu.Visible = True
        Else
            LinkSelectedMenu.Visible = False
        End If
       

    End Sub

    Protected Sub LinkButtonSelectAll_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LinkButtonSelectAll.Click
        Dim i As Integer
        For i = 0 To LinksGrodView.Rows.Count - 1
            Dim Ch As CheckBox = LinksGrodView.Rows(i).FindControl("ChLinkSelected")
            Ch.Checked = True

        Next
    End Sub

    Protected Sub LinkButtonDeselectAll_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LinkButtonDeselectAll.Click
        Dim i As Integer
        For i = 0 To LinksGrodView.Rows.Count - 1
            Dim Ch As CheckBox = LinksGrodView.Rows(i).FindControl("ChLinkSelected")
            Ch.Checked = False

        Next
    End Sub

    Protected Sub LinkButtonDeleteSelected_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LinkButtonDeleteSelected.Click
        LabelUrlFaild.Visible = False
        LabelUrlSuccess.Visible = False
        Dim i As Integer
        Dim MustDelete As Integer
        Dim FlagDelete As Integer
        For i = 0 To LinksGrodView.Rows.Count - 1
            Dim ch As CheckBox = LinksGrodView.Rows(i).FindControl("ChLinkSelected")
            If ch.Checked = True Then
                MustDelete += 1
                Dim LinkID As HiddenField = LinksGrodView.Rows(i).FindControl("HiddenLinkID")
                Dim Result As Integer = LinkService.DeleteLinkByLinkID(LinkID.Value)
                If Result = 0 Then
                    LabelUrlFaild.Visible = True
                ElseIf Result = 1 Then
                    FlagDelete += 1
                ElseIf Result = -1000 Then
                    LabelUrlFaild.Visible = True
                End If
            End If
        Next
        If MustDelete <> FlagDelete Then
            LabelUrlFaild.Visible = True
        ElseIf MustDelete = FlagDelete And MustDelete <> 0 Then
            LabelUrlSuccess.Visible = True
        End If
        treeload()
        LinksGrodView.DataBind()
        If LinksGrodView.Rows.Count > 0 Then
            LinkSelectedMenu.Visible = True
        Else
            LinkSelectedMenu.Visible = False
        End If
    End Sub

    Protected Sub LinkButtonAllSelected_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LinkButtonAllSelected.Click
        Dim i As Integer
        For i = 0 To GridViewLinkCategories.Rows.Count - 1
            Dim Ch As CheckBox = GridViewLinkCategories.Rows(i).FindControl("ChCategorySelected")
            Ch.Checked = True

        Next
    End Sub

    Protected Sub LinkButtonNoneSelected_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LinkButtonNoneSelected.Click
        Dim i As Integer
        For i = 0 To GridViewLinkCategories.Rows.Count - 1
            Dim Ch As CheckBox = GridViewLinkCategories.Rows(i).FindControl("ChCategorySelected")
            Ch.Checked = False

        Next
    End Sub

    Protected Sub LinkButtonDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LinkButtonDelete.Click
        LabelSuccessLinkCategory.Visible = False
        LabelFailedLinkCategory.Visible = False
        Dim i As Integer
        Dim MustDelete As Integer
        Dim FlagDelete As Integer
        For i = 0 To GridViewLinkCategories.Rows.Count - 1
            Dim ch As CheckBox = GridViewLinkCategories.Rows(i).FindControl("ChCategorySelected")
            If ch.Checked = True Then
                MustDelete += 1
                Dim CategoryID As HiddenField = GridViewLinkCategories.Rows(i).FindControl("HiddenFieldCategoryID")
                Dim Result As Integer = LinkService.DeletelinkCategoryByLinkCategoryID(CategoryID.Value)
                
                If Result = 1 Or Result = -2 Then
                    FlagDelete += 1
                ElseIf Result = -1000 Then
                    LabelFailedLinkCategory.Visible = True
                End If
            End If
        Next
        If MustDelete <> FlagDelete Then
            LabelFailedLinkCategory.Visible = True
        ElseIf MustDelete = FlagDelete And MustDelete <> 0 Then
            LabelSuccessLinkCategory.Visible = True
        End If
        treeload()
        ListCatagoryName.DataBind()
        DropDown()
        GridViewLinkCategories.DataBind()
        If GridViewLinkCategories.Rows.Count > 0 Then
            CategorySelectedMenu.Visible = True
        Else
            CategorySelectedMenu.Visible = False
        End If
    End Sub

    Public Function CreateURL(ByVal ID As Long) As String
        Return "Picture.aspx?linkid=" + ID.ToString
    End Function

    Protected Sub BtnCancelLink_Click(ByVal sender As Object, ByVal e As EventArgs) Handles BtnCancelLink.Click
        Response.Redirect("~/CPanel/Default.aspx")
    End Sub
End Class